/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLivingBase;
import noppes.npcs.api.entity.IPlayer;

public class NpcEvent
extends Event {
    public final ICustomNpc npc;

    public NpcEvent(ICustomNpc npc) {
        this.npc = npc;
    }

    public static class TimerEvent
    extends NpcEvent {
        public final int id;

        public TimerEvent(ICustomNpc npc, int id) {
            super(npc);
            this.id = id;
        }
    }

    public static class CollideEvent
    extends NpcEvent {
        public final IEntity entity;

        public CollideEvent(ICustomNpc npc, Entity entity) {
            super(npc);
            this.entity = NpcAPI.Instance().getIEntity(entity);
        }
    }

    @Cancelable
    public static class DamagedEvent
    extends NpcEvent {
        public final IEntity source;
        public final DamageSource mcDamageSource;
        public float damage;
        public boolean clearTarget = false;

        public DamagedEvent(ICustomNpc npc, Entity source, float damage, DamageSource mcDamageSource) {
            super(npc);
            this.source = NpcAPI.Instance().getIEntity(source);
            this.damage = damage;
            this.mcDamageSource = mcDamageSource;
        }
    }

    @Cancelable
    public static class RangedLaunchedEvent
    extends NpcEvent {
        public final IEntityLivingBase target;
        public float damage;

        public RangedLaunchedEvent(ICustomNpc npc, EntityLivingBase target, float damage) {
            super(npc);
            this.target = (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)target);
            this.damage = damage;
        }
    }

    @Cancelable
    public static class MeleeAttackEvent
    extends NpcEvent {
        public final IEntityLivingBase target;
        public float damage;

        public MeleeAttackEvent(ICustomNpc npc, EntityLivingBase target, float damage) {
            super(npc);
            this.target = (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)target);
            this.damage = damage;
        }
    }

    public static class KilledEntityEvent
    extends NpcEvent {
        public final IEntityLivingBase entity;

        public KilledEntityEvent(ICustomNpc npc, EntityLivingBase entity) {
            super(npc);
            this.entity = (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)entity);
        }
    }

    public static class DiedEvent
    extends NpcEvent {
        public final DamageSource mcDamageSource;
        public final String type;
        public final IEntity source;

        public DiedEvent(ICustomNpc npc, DamageSource damagesource, Entity entity) {
            super(npc);
            this.mcDamageSource = damagesource;
            this.type = damagesource.field_76373_n;
            this.source = NpcAPI.Instance().getIEntity(entity);
        }
    }

    @Cancelable
    public static class InteractEvent
    extends NpcEvent {
        public final IPlayer player;

        public InteractEvent(ICustomNpc npc, EntityPlayer player) {
            super(npc);
            this.player = (IPlayer)NpcAPI.Instance().getIEntity((Entity)player);
        }
    }

    @Cancelable
    public static class TargetLostEvent
    extends NpcEvent {
        public final IEntityLivingBase entity;

        public TargetLostEvent(ICustomNpc npc, EntityLivingBase entity) {
            super(npc);
            this.entity = (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)entity);
        }
    }

    @Cancelable
    public static class TargetEvent
    extends NpcEvent {
        public IEntityLivingBase entity;

        public TargetEvent(ICustomNpc npc, EntityLivingBase entity) {
            super(npc);
            this.entity = (IEntityLivingBase)NpcAPI.Instance().getIEntity((Entity)entity);
        }
    }

    public static class UpdateEvent
    extends NpcEvent {
        public UpdateEvent(ICustomNpc npc) {
            super(npc);
        }
    }

    public static class InitEvent
    extends NpcEvent {
        public InitEvent(ICustomNpc npc) {
            super(npc);
        }
    }
}

